/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package handlingExceptons;

import java.io.FileNotFoundException;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class StartHere {

    public static void main(String[] args) throws FileNotFoundException{

        fileProblems();//This method raises a checked exception and must have try-catch clause (below)
        //...or add the throws clause to the method definition (above).
        
        //Trivial try-catch clause - ignore any problems opening the file.
        try {
            fileProblems();
        } catch (FileNotFoundException fnf) {
        }
        

        //More realistic example - print out a nice message
/*        try {
            //Run some code that tries to divide by 0
            double result = arithmeticProblems(1, 0);
        } catch (ArithmeticException ae) {
            //Various options for messages you could print out.
            System.out.println("Sorry you can't divide by 0!");
            //Print out the error message
            System.out.println("The error was: " + ae.getClass());
            System.out.println("The error message was: " + ae.getMessage());
            //Print out a stack trace
            System.out.println("The stack trace is: ");
            ae.printStackTrace(System.out);
        }
         */
        //Handling the exceptions in the method
//        System.out.println("The results is: "+arithmeticNoProblems(1,0));
        //Rewritten method using the finally clause
//        System.out.println("The results is: "+arithmeticNoProblemsFinally(1,0));
    }

    //Methods which raise some common exceptions and errors.
    public static void memoryProblems() {
        throw new OutOfMemoryError();
    }

    public static void arrayProblems() {
        int[] myArray = {1, 2, 3};
        //This will generate an ArrayIndexOutOfBoundException
        System.out.println("Value in position 4: " + myArray[3]);
    }

    public static double arithmeticProblems(int a, int b) {
        //This could generate an ArithmeticException.
        return a / b;
    }

    public static void fileProblems() throws FileNotFoundException {
        //Causes a checked exception but doesn't have a try catch clause to deal with it.
        //Hence must have the throws FileNotFoundException declaration in the method header above.
        throw new FileNotFoundException();
    }

    public static double arithmeticNoProblems(int a, int b) {
        try {
            //This will generate an ArithmeticException.
            return a / b;
        } catch (ArithmeticException ae) {
            System.out.println("Sorry you can't divide by 0!");
            return 0;//We have to return something!
        }
    }

    public static double arithmeticNoProblemsFinally(int a, int b) {
        double result = 0;
        try {
            //This will generate an ArithmeticException.
            result = a / b;
        } catch (ArithmeticException ae) {
            System.out.println("Sorry you can't divide by 0!");
        } finally {
            return result;
        }
    }
}
